#######################################################
# cjgb, 20121128
# código para la charla del grupo de usuarios de R
#       de Madrid
#######################################################

library(MicroDatosEs)

raw.epa <- epa2005("EPAWEBT0312")
class(raw.epa) # data.set (del paquete "survey")
dat.epa <- as.data.frame(raw.epa)

dim(dat.epa)
#[1] 169649     93

# cálculo de la tasa de paro (25.02 %)
tasa.paro <- dat.epa[ grep("Inactivos", dat.epa$aoi, invert=T),]
tasa.paro <- tasa.paro[ !is.na(tasa.paro$aoi),]
tasa.paro$aoi <- factor(tasa.paro$aoi)
tmp <- sum(tasa.paro$factorel) / 100
xtabs( factorel ~ aoi, data = tasa.paro ) / tmp


# factorel: factor de elevación
hist(dat.epa$factorel / 100)
fivenum(dat.epa$factorel / 100)
# [1]   28.01  140.55  201.74  318.01 6838.06

# aoi: clasificación laboral de la persona
table(dat.epa$aoi)
#Ocupados subempleados por insuficiencia de horas 
#7618 
#Resto de ocupados 
#52739 
#Parados que buscan primer empleo 
#1995 
#Parados que han trabajado antes 
#17109 
#Inactivos 1 (desanimados) 
#1829 
#Inactivos 2 (junto con los desanimados forman los activos potenciales) 
#971 
#Inactivos 3 (resto de inactivos) 
#60788 

# varianza de las estimaciones
epa.var <- subset(tasa.paro, select = c(aoi, factorel,prov,ccaa))
levels(epa.var$aoi) <- c("ocupados", "ocupados", "parados", "parados")
tmp <- sum(epa.var$factorel) / 100
xtabs( factorel ~ aoi, data = epa.var ) / tmp

tasa <- 0.25
tmp <- 100 * epa.var$factorel / sum(epa.var$factorel)
res <- replicate(1000, sum( tmp * rbinom(nrow(epa.var), 1, tasa)) )
hist(res)
fivenum(res)
#[1] 24.30146 24.85846 24.98817 25.13586 25.55444

epa.madrid <- subset(epa.var, ccaa == "Madrid (Comunidad de)")
tmp <- sum(epa.madrid$factorel) / 100
xtabs( factorel ~ aoi, data = epa.madrid ) / tmp
tasa <- 0.1856
tmp <- 100 * epa.madrid$factorel / sum(epa.madrid$factorel)
res <- replicate(1000, sum( tmp * rbinom(nrow(epa.madrid), 1, tasa)) )
hist(res)
fivenum(res)
#[1] 16.67082 18.14820 18.60928 19.06935 20.77782

epa.rioja <- subset(epa.var, ccaa == "Rioja (La)")
tmp <- sum(epa.rioja$factorel) / 100
xtabs( factorel ~ aoi, data = epa.rioja ) / tmp
tasa <- 0.2032
tmp <- 100 * epa.rioja$factorel / sum(epa.rioja$factorel)
res <- replicate(1000, sum( tmp * rbinom(nrow(epa.rioja), 1, tasa)) )
hist(res)
fivenum(res)
#[1] 16.66753 19.51839 20.34967 21.08246 23.43207

